function updateClasses(theme) {
    // replace id="showbacktop"
    let showbacktop = document.getElementById('showbacktop');
    if (!showbacktop) return;
    if (theme === 'dark') {
        if (showbacktop.classList.contains('bg-white')) {
            showbacktop.classList.replace('bg-white', 'bg-black');
        }
    } else {
        if (showbacktop.classList.contains('bg-black')) {
            showbacktop.classList.replace('bg-black', 'bg-white');
        }
    }

    // replace id="mobile-menu"
    let mobileMenu = document.getElementById('mobile-menu');
    if (!mobileMenu) return;
    if (theme === 'dark') {
        if (mobileMenu.classList.contains('bg-white')) {
            mobileMenu.classList.replace('bg-white', 'bg-black');
        }
    } else {
        if (mobileMenu.classList.contains('bg-black')) {
            mobileMenu.classList.replace('bg-black', 'bg-white');
        }
    }

    // replace id="main-menu" 
    let mainMenu = document.getElementById('main-menu');
    if (!mainMenu) return;
    if (theme === 'dark') {
        if (mainMenu.classList.contains('navbar-light')) {
            mainMenu.classList.replace('navbar-light', 'navbar-dark');
        }
    } else {
        if (mainMenu.classList.contains('navbar-dark')) {
            mainMenu.classList.replace('navbar-dark', 'navbar-light');
        }
    }

    // replace class .sidenav-menu>.navbar
    let sidenavMenuNavbars = document.querySelectorAll('.sidenav-menu > .navbar');
    if (!sidenavMenuNavbars.length) return;
    sidenavMenuNavbars.forEach(navbar => {
        if (theme === 'dark') {
            if (navbar.classList.contains('navbar-light')) {
                navbar.classList.replace('navbar-light', 'navbar-dark');
            }
        } else {
            if (navbar.classList.contains('navbar-dark')) {
                navbar.classList.replace('navbar-dark', 'navbar-light');
            }
        }
    });
}

function applyTheme(theme) {
    var htmlElement = document.documentElement;
    var themeIcon = document.getElementById('theme-icon');

    if (theme === 'dark') {
        htmlElement.setAttribute('data-bs-theme', 'dark');
        themeIcon.classList.remove('bi-sun');
        themeIcon.classList.add('bi-moon');
        document.body.classList.remove('light-theme');
        document.body.classList.add('dark-theme');
    } else {
        htmlElement.setAttribute('data-bs-theme', 'light');
        themeIcon.classList.remove('bi-moon');
        themeIcon.classList.add('bi-sun');
        document.body.classList.remove('dark-theme');
        document.body.classList.add('light-theme');
    }
    
    updateClasses(theme); // call updateClasses
}

// Load localStorage theme on DOMContentLoaded
document.addEventListener('DOMContentLoaded', function () {
    var savedTheme = localStorage.getItem('theme') || 'light';
    applyTheme(savedTheme);
});

// Toggle theme on button click
document.getElementById('theme-toggle').addEventListener('click', function () {
    var currentTheme = document.documentElement.getAttribute('data-bs-theme');
    var newTheme = currentTheme === 'light' ? 'dark' : 'light';
    applyTheme(newTheme);
    localStorage.setItem('theme', newTheme);
});
