import gulp from 'gulp';
import sassPkg from 'gulp-sass';
import * as sassCompiler from 'sass';
const sass = sassPkg(sassCompiler);
import changed from 'gulp-changed';
import rtlcss from 'gulp-rtlcss';
import rename from 'gulp-rename';
import { deleteAsync } from 'del';
import concat from 'gulp-concat';
import cssnano from 'gulp-cssnano';
import terser from 'gulp-terser';
import sourcemaps from 'gulp-sourcemaps';
import browserSyncPkg from 'browser-sync';
const browserSync = browserSyncPkg.create();
import autoprefixer from 'gulp-autoprefixer';

// BrowserSync
function serve() {
  browserSync.init({
    files: "./*.html",
    startPath: "./html/home/",
    server: {
      baseDir: "./",
    },
  });
}

// Clean dist
function clean() {
    return deleteAsync(["./dist/"]);
}

// Clean plugins
function cleanplugins() {
    return deleteAsync(["./assets/vendor/"]);
}

// Compile SCSS files into CSS
function defaultcss() {
  return gulp
    .src("./assets/scss/*.scss")
    .pipe(sourcemaps.init())
    .pipe(changed('./assets/css/'))
    .pipe(sass({ outputStyle: "expanded" }))
    .pipe(sass().on('error', sass.logError))
    .pipe(autoprefixer([
        "last 1 major version",
        ">= 1%",
        "Chrome >= 45",
        "Firefox >= 38",
        "Edge >= 12",
        "Explorer >= 10",
        "iOS >= 9",
        "Safari >= 9",
        "Android >= 4.4",
        "Opera >= 30"], { cascade: true }))
    .pipe(sourcemaps.write(''))
    .pipe(gulp.dest("./assets/css/"))
    .pipe(browserSync.stream());
}

// move css to dist
function movecss() {
  return gulp
    .src("./assets/css/theme.css")
    .pipe(sourcemaps.init())
    .pipe(cssnano())
    .pipe(concat('theme.min.css'))
    .pipe(sourcemaps.write(''))
    .pipe(gulp.dest('./dist/css/'));
}

// JS theme minifier
function defaultjs() {
  return gulp
    .src("./assets/js/theme.js")
    .pipe(concat('theme.min.js'))
    .pipe(terser())
    .pipe(gulp.dest('./dist/js/'));
}

// Compile RTL CSS
function cssrtl() {
  return gulp
    .src(['./assets/css/theme.css'])
    .pipe(sourcemaps.init())
    .pipe(autoprefixer(["last 2 versions", "> 1%"])) // Other post-processing.
    .pipe(rtlcss()) // Convert to RTL.
    .pipe(rename({ suffix: '-rtl' })) // Append "-rtl" to the filename.
    .pipe(sourcemaps.write('')) // Output source maps.
    .pipe(gulp.dest('./assets/css/')); // Output RTL stylesheets.
}

// CSS theme minifier
function mincssrtl() {
  return gulp
    .src(["./assets/css/theme-rtl.css"])
    .pipe(sourcemaps.init())
    .pipe(cssnano())
    .pipe(concat('bundle-rtl.min.css'))
    .pipe(sourcemaps.write(''))
    .pipe(gulp.dest('./dist/css/'));
}

// JS theme minifier
function minjsrtl() {
  return gulp
    .src([
      "./assets/vendor/bootstrap/dist/js/bootstrap.bundle.min.js",
      "./assets/vendor/hc-sticky/dist/hc-sticky.js",
      "./assets/vendor/flickity/dist/flickity.pkgd.min.js",
      "./assets/vendor/vanilla-lazyload/dist/lazyload.min.js",
      "./assets/vendor/smoothscroll-for-websites/SmoothScroll.js",
      "./assets/js/theme-rtl.js"])
    .pipe(concat('bundle-rtl.min.js'))
    .pipe(terser())
    .pipe(gulp.dest('./dist/js/'));
}

// CSS theme minifier
function mincss() {
  return gulp
    .src(["./assets/css/theme.css"])
    .pipe(sourcemaps.init())
    .pipe(cssnano())
    .pipe(concat('bundle.min.css'))
    .pipe(sourcemaps.write(''))
    .pipe(gulp.dest('./dist/css/'));
}

// JS theme minifier
function minjs() {
  return gulp
    .src([
      "./assets/vendor/bootstrap/dist/js/bootstrap.bundle.min.js",
      "./assets/vendor/hc-sticky/dist/hc-sticky.js",
      "./assets/vendor/flickity/dist/flickity.pkgd.min.js",
      "./assets/vendor/vanilla-lazyload/dist/lazyload.min.js",
      "./assets/vendor/smoothscroll-for-websites/SmoothScroll.js",
      "./assets/js/theme.js"])
    .pipe(concat('bundle.min.js'))
    .pipe(terser())
    .pipe(gulp.dest('./dist/js/'));
}

// Copy File from vendors
function copyvendors() {
  return gulp
  .src([
    './node_modules/*bootstrap/**/*',
    './node_modules/*flickity/**/*',
    './node_modules/*vanilla-lazyload/**/*',
    './node_modules/*smoothscroll-for-websites/**/*',
    './node_modules/*hc-sticky/**/*'
  ])
  .pipe(gulp.dest('./assets/vendor/'));
}

// Watch files
function watchFiles() {
  gulp.watch('./assets/scss/**/*.scss', defaultcss);
  gulp.watch('./assets/js/**/*.js').on('change', browserSync.reload);
  gulp.watch('./*.html').on('change', browserSync.reload);
  gulp.watch('./**/**/*.html').on('change', browserSync.reload);
}

// define complex tasks
const starter = gulp.parallel(watchFiles, defaultcss, serve);

// build system
const css = gulp.series(defaultcss, cssrtl, gulp.parallel(movecss, mincss, mincssrtl));
const js = gulp.parallel(defaultjs, minjs, minjsrtl);
const build = gulp.series(clean, gulp.parallel(css, js));

const copyplugins = gulp.series(cleanplugins, copyvendors);

// export tasks
export { css };
export { cssrtl };
export { mincssrtl };
export { minjsrtl };
export { js };
export { copyplugins };
export { build };
export { clean };
export default starter;
